<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * MagicLogin\Dependencies\Twilio - Assistants
 * This is the public MagicLogin\Dependencies\Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace MagicLogin\Dependencies\Twilio\Rest\Assistants\V1\Assistant;

use MagicLogin\Dependencies\Twilio\Exceptions\TwilioException;
use MagicLogin\Dependencies\Twilio\InstanceResource;
use MagicLogin\Dependencies\Twilio\Values;
use MagicLogin\Dependencies\Twilio\Version;


/**
 * @property string $status
 * @property bool $flagged
 * @property bool $aborted
 * @property string $sessionId
 * @property string $accountSid
 * @property string $body
 * @property string $error
 */
class MessageInstance extends InstanceResource
{
    /**
     * Initialize the MessageInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $id the Assistant ID.
     */
    public function __construct(Version $version, array $payload, string $id)
    {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'status' => Values::array_get($payload, 'status'),
            'flagged' => Values::array_get($payload, 'flagged'),
            'aborted' => Values::array_get($payload, 'aborted'),
            'sessionId' => Values::array_get($payload, 'session_id'),
            'accountSid' => Values::array_get($payload, 'account_sid'),
            'body' => Values::array_get($payload, 'body'),
            'error' => Values::array_get($payload, 'error'),
        ];

        $this->solution = ['id' => $id, ];
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name)
    {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Assistants.V1.MessageInstance]';
    }
}

