<?php

declare(strict_types=1);

namespace MagicLogin\Dependencies\Endroid\QrCode;

use MagicLogin\Dependencies\Endroid\QrCode\Color\ColorInterface;
use MagicLogin\Dependencies\Endroid\QrCode\Encoding\EncodingInterface;
use MagicLogin\Dependencies\Endroid\QrCode\ErrorCorrectionLevel\ErrorCorrectionLevelInterface;
use MagicLogin\Dependencies\Endroid\QrCode\RoundBlockSizeMode\RoundBlockSizeModeInterface;

interface QrCodeInterface
{
    public function getData(): string;

    public function getEncoding(): EncodingInterface;

    public function getErrorCorrectionLevel(): ErrorCorrectionLevelInterface;

    public function getSize(): int;

    public function getMargin(): int;

    public function getRoundBlockSizeMode(): RoundBlockSizeModeInterface;

    public function getForegroundColor(): ColorInterface;

    public function getBackgroundColor(): ColorInterface;
}
