<?php

/*
Plugin Name:  Flat-Six Utilities
Plugin URI:   https://flat-six.net
Description:  Contains functions used by every WordPress website at Flat-Six
Version:      1.6
Author:       Flat-Six
Author URI:   https://flat-six.net
License:      N/A
License URI:  N/A
Text Domain:  f6-util
Domain Path:  /languages
*/

/* Hooks */
// Hook into the 'admin_menu' action to execute the function.
add_action('admin_menu', 'remove_admin_menu_items_for_user_callback', 999);
// Disable the notification email from Gravity Forms.
add_filter('gform_disable_notification', 'send_mail_to_mailchannels_callback', 10, 4);
// Add Google Tag Manager to wp_head
add_action('wp_head', 'f6_gtm_head');
// Add Google Tag Manager to wp_body
add_action('wp_body_open', 'f6_gtm_body');
// Format the Gravity Forms submit button
add_filter('gform_submit_button', 'add_custom_css_classes', 10, 2);

/* Callbacks */

// Callbacks are used to set variables
function remove_admin_menu_items_for_user_callback()
{
    // Replace with the specific username you want to target.
    $target_user_name = 'pcs-admin'; // Example: Remove menus for username 'admin'

    remove_admin_menu_items_for_user($target_user_name);
}

function send_mail_to_mailchannels_callback($is_disabled, $notification, $entry, $form): bool
{
    // Replace with your own authentication information.
    $auth_info = array(
            'api_key' => 'wcvRStH8ZbIHldo8oIesVwgXD6rIvKig',
    );

    // Only send emails to the admin (drop user notifications)
    if ($notification['name'] == 'Admin Notification') {
        // Get site url and reduce it to example.com only
        $pattern = '/https?:\/\/([^\/]+)/';
        $site_url = get_option('siteurl');

        if (preg_match($pattern, $site_url, $matches)) {
            $site_domain = $matches[1];
        }

        // Set variables for email
        $send_to_email = $notification['toEmail'];

        $send_from_email = "noreply@$site_domain";
        $send_from_name = get_option('blogname') . ' Contact Form';

        $reply_to_email = $form[2];
        $reply_to_name = "{$form['1.3']} {$form['1.6']}";

        $subject = $notification['subject'];
        $message = $notification['message'];

        // Replace variables in text
        $subject = str_replace('{form_title}', $entry['title'], $subject);

        $message = str_replace('{all_fields}', "Name: {$form['1.3']} {$form['1.6']}\nEmail: {$form['2']}\nQuestions / Comments:\n{$form['3']}", $message);
        $message = str_replace('{Email:2}', $form['2'], $message);
        $message = str_replace('{Name (First):1.3}', $form['1.3'], $message);
        $message = str_replace('{Name (Last):1.6}', $form['1.6'], $message);

        $message_html = nl2br(htmlspecialchars($message));

        // Create an HTML Wrapper for the HTML formatted message
        $message_html = "
		<html lang='en'>
			<head>
				<title>$subject</title>
			</head>
			<body>
				<p>" . $message_html . "</p>
			</body>
		</html>";


        // Send email
        send_email(
                $auth_info,
                $send_to_email,
                '',
                $send_from_email,
                $send_from_name,
                $reply_to_email,
                $reply_to_name,
                $subject,
                $message,
                $message_html
        );
    }

    return true;
}

/* Functions */

function add_custom_css_classes($button, $form)
{
    $dom = new DOMDocument();
    $dom->loadHTML('<?xml encoding="utf-8" ?>' . $button);
    $input = $dom->getElementsByTagName('input')->item(0);
    $classes = $input->getAttribute('class');
    $classes .= " uk-button uk-button-primary";
    $input->setAttribute('class', $classes);
    return $dom->saveHtml($input);
}

function remove_admin_menu_items_for_user($username)
{
    $current_user = wp_get_current_user();

    if ($current_user->exists()) {
        // Get the username
        $current_username = $current_user->user_login;
    } else {
        $current_username = '';
    }
    // Check if the current user matches the target username.
    if ($current_username == $username) {

        // Array of admin menu item slugs to remove.
        $menu_items_to_remove = array(
                'link-manager.php',   // Links (if enabled)
                'edit-comments.php',  // Comments
                'themes.php',         // Appearance
                'plugins.php',        // Plugins
                'tools.php',          // Tools
                'snippets',           // Snippets
                'profile.php',        // Profile
                'index.php',          // Dashboard
                'users.php',          // Users
        );
        // Loop through the menu items to remove.
        foreach ($menu_items_to_remove as $menu_item) {
            remove_menu_page($menu_item);
        }
        $settings_menues_to_remove = array(
                'options-writing.php',                          // Writing
                'options-reading.php',                          // Reading
                'options-media.php',                            // Media
                'options-discussion.php',                       // Discussion
                'options-permalink.php',                        // Permalinks
                'options-privacy.php',                          // Privacy
                'options-general.php?page=tinymce-advanced',    // TinyMCE

        );
        // Loop through the menu items to remove.
        foreach ($settings_menues_to_remove as $menu_item) {
            remove_submenu_page('options-general.php', $menu_item);
        }
//		remove_submenu_page( 'options-general.php', 'options-discussion.php' );  //Remove Discussion sub-menu from Settings
    }
}

function f6_gtm_head()
{
    ?>
    <!-- Google Tag Manager -->
    <script>(function (w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({
                'gtm.start':
                    new Date().getTime(), event: 'gtm.js'
            });
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s), dl = l != 'dataLayer' ? '&l=' + l : '';
            j.async = true;
            j.src =
                'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', 'GTM-T4PVVWLQ');</script>
    <!-- End Google Tag Manager -->
    <?php
}

function f6_gtm_body()
{
    ?>
    <!-- Google Tag Manager (noscript) -->
    <noscript>
        <iframe src="https://www.googletagmanager.com/ns.html?id=GTM-T4PVVWLQ"
                height="0" width="0" style="display:none;visibility:hidden">
        </iframe>
    </noscript>
    <!-- End Google Tag Manager (noscript) -->
    <?php
}

/* Helper Functions */

function send_email($auth_info, $send_to_email, $send_to_name, $send_from_email, $send_from_name, $reply_to_email, $reply_to_name, $subject, $message_plain, $message_html)
{
    $curl = curl_init();

    curl_setopt_array($curl, [
            CURLOPT_URL => "https://api.mailchannels.net/tx/v1/send",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode([
                    'personalizations' => [
                            [
                                    'to' => [
                                            [
                                                    'email' => $send_to_email,
                                                    'name' => $send_to_name
                                            ]
                                    ]
                            ]
                    ],
//			'dkim_domain'      => $auth_info['main_domain'],
//			'dkim_selector'    => $auth_info['dkim_selector'],
//			'dkim_private_key' => $auth_info['dkim_private_key'],
                    'from' => [
                            'email' => $send_from_email,
                            'name' => $send_from_name
                    ],
                    'reply_to' => [
                            'email' => $reply_to_email,
                            'name' => $reply_to_name
                    ],
                    'subject' => $subject,
                    'content' => [
//				[
//					'type'  => 'text/plain',
//					'value' => $message_plain
//				],
                            [
                                    'type' => 'text/html',
                                    'value' => $message_html
                            ]
                    ]
            ]),
            CURLOPT_HTTPHEADER => [
                    "accept: application/json",
                    "content-type: application/json",
                    "x-api-key: {$auth_info['api_key']}"
            ],
    ]);

    $response = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);

    // Un-comment this to print the results of cURL to the screen
//	if ( $err ) {
//		echo "cURL Error #:" . $err . "\n\n";
//	} else {
//		echo $response . "\n\n";
//	}
}
