<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * MagicLogin\Dependencies\Twilio - Taskrouter
 * This is the public MagicLogin\Dependencies\Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace MagicLogin\Dependencies\Twilio\Rest\Taskrouter\V1\Workspace\Workflow;

use MagicLogin\Dependencies\Twilio\Exceptions\TwilioException;
use MagicLogin\Dependencies\Twilio\InstanceResource;
use MagicLogin\Dependencies\Twilio\Options;
use MagicLogin\Dependencies\Twilio\Values;
use MagicLogin\Dependencies\Twilio\Version;


/**
 * @property string|null $accountSid
 * @property array|null $cumulative
 * @property array|null $realtime
 * @property string|null $workflowSid
 * @property string|null $workspaceSid
 * @property string|null $url
 */
class WorkflowStatisticsInstance extends InstanceResource
{
    /**
     * Initialize the WorkflowStatisticsInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $workspaceSid The SID of the Workspace with the Workflow to fetch.
     * @param string $workflowSid Returns the list of Tasks that are being controlled by the Workflow with the specified SID value.
     */
    public function __construct(Version $version, array $payload, string $workspaceSid, string $workflowSid)
    {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'accountSid' => Values::array_get($payload, 'account_sid'),
            'cumulative' => Values::array_get($payload, 'cumulative'),
            'realtime' => Values::array_get($payload, 'realtime'),
            'workflowSid' => Values::array_get($payload, 'workflow_sid'),
            'workspaceSid' => Values::array_get($payload, 'workspace_sid'),
            'url' => Values::array_get($payload, 'url'),
        ];

        $this->solution = ['workspaceSid' => $workspaceSid, 'workflowSid' => $workflowSid, ];
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     *
     * @return WorkflowStatisticsContext Context for this WorkflowStatisticsInstance
     */
    protected function proxy(): WorkflowStatisticsContext
    {
        if (!$this->context) {
            $this->context = new WorkflowStatisticsContext(
                $this->version,
                $this->solution['workspaceSid'],
                $this->solution['workflowSid']
            );
        }

        return $this->context;
    }

    /**
     * Fetch the WorkflowStatisticsInstance
     *
     * @param array|Options $options Optional Arguments
     * @return WorkflowStatisticsInstance Fetched WorkflowStatisticsInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(array $options = []): WorkflowStatisticsInstance
    {

        return $this->proxy()->fetch($options);
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name)
    {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Taskrouter.V1.WorkflowStatisticsInstance ' . \implode(' ', $context) . ']';
    }
}

