<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * MagicLogin\Dependencies\Twilio - Pricing
 * This is the public MagicLogin\Dependencies\Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace MagicLogin\Dependencies\Twilio\Rest\Pricing\V2;

use MagicLogin\Dependencies\Twilio\Exceptions\TwilioException;
use MagicLogin\Dependencies\Twilio\ListResource;
use MagicLogin\Dependencies\Twilio\Version;
use MagicLogin\Dependencies\Twilio\InstanceContext;
use MagicLogin\Dependencies\Twilio\Rest\Pricing\V2\Voice\CountryList;
use MagicLogin\Dependencies\Twilio\Rest\Pricing\V2\Voice\NumberList;


/**
 * @property CountryList $countries
 * @property NumberList $numbers
 * @method \MagicLogin\Dependencies\Twilio\Rest\Pricing\V2\Voice\CountryContext countries(string $isoCountry)
 * @method \MagicLogin\Dependencies\Twilio\Rest\Pricing\V2\Voice\NumberContext numbers(string $destinationNumber)
 */
class VoiceList extends ListResource
    {
    protected $_countries = null;
    protected $_numbers = null;

    /**
     * Construct the VoiceList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(
        Version $version
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        ];
    }

    /**
     * Access the countries
     */
    protected function getCountries(): CountryList
    {
        if (!$this->_countries) {
            $this->_countries = new CountryList(
                $this->version
            );
        }
        return $this->_countries;
    }

    /**
     * Access the numbers
     */
    protected function getNumbers(): NumberList
    {
        if (!$this->_numbers) {
            $this->_numbers = new NumberList(
                $this->version
            );
        }
        return $this->_numbers;
    }

    /**
     * Magic getter to lazy load subresources
     *
     * @param string $name Subresource to return
     * @return \MagicLogin\Dependencies\Twilio\ListResource The requested subresource
     * @throws TwilioException For unknown subresources
     */
    public function __get(string $name)
    {
        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown subresource ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     * @return InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call(string $name, array $arguments): InstanceContext
    {
        $property = $this->$name;
        if (\method_exists($property, 'getContext')) {
            return \call_user_func_array(array($property, 'getContext'), $arguments);
        }

        throw new TwilioException('Resource does not have a context');
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Pricing.V2.VoiceList]';
    }
}
