<?php
declare(strict_types = 1);

namespace MagicLogin\Dependencies\DASPRiD\Enum;

use MagicLogin\Dependencies\DASPRiD\Enum\Exception\CloneNotSupportedException;
use MagicLogin\Dependencies\DASPRiD\Enum\Exception\SerializeNotSupportedException;
use MagicLogin\Dependencies\DASPRiD\Enum\Exception\UnserializeNotSupportedException;

final class NullValue
{
    /**
     * @var self
     */
    private static $instance;

    private function __construct()
    {
    }

    public static function instance() : self
    {
        return self::$instance ?: self::$instance = new self();
    }

    /**
     * Forbid cloning enums.
     *
     * @throws CloneNotSupportedException
     */
    final public function __clone()
    {
        throw new CloneNotSupportedException();
    }

    /**
     * Forbid serializing enums.
     *
     * @throws SerializeNotSupportedException
     */
    final public function __sleep() : array
    {
        throw new SerializeNotSupportedException();
    }

    /**
     * Forbid unserializing enums.
     *
     * @throws UnserializeNotSupportedException
     */
    final public function __wakeup() : void
    {
        throw new UnserializeNotSupportedException();
    }
}
