<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * MagicLogin\Dependencies\Twilio - Insights
 * This is the public MagicLogin\Dependencies\Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace MagicLogin\Dependencies\Twilio\Rest\Insights\V1\Call;

use MagicLogin\Dependencies\Twilio\Exceptions\TwilioException;
use MagicLogin\Dependencies\Twilio\InstanceResource;
use MagicLogin\Dependencies\Twilio\Values;
use MagicLogin\Dependencies\Twilio\Version;


/**
 * @property string|null $timestamp
 * @property string|null $callSid
 * @property string|null $accountSid
 * @property string $edge
 * @property string|null $group
 * @property string $level
 * @property string|null $name
 * @property array|null $carrierEdge
 * @property array|null $sipEdge
 * @property array|null $sdkEdge
 * @property array|null $clientEdge
 */
class EventInstance extends InstanceResource
{
    /**
     * Initialize the EventInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $callSid The unique SID identifier of the Call.
     */
    public function __construct(Version $version, array $payload, string $callSid)
    {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'timestamp' => Values::array_get($payload, 'timestamp'),
            'callSid' => Values::array_get($payload, 'call_sid'),
            'accountSid' => Values::array_get($payload, 'account_sid'),
            'edge' => Values::array_get($payload, 'edge'),
            'group' => Values::array_get($payload, 'group'),
            'level' => Values::array_get($payload, 'level'),
            'name' => Values::array_get($payload, 'name'),
            'carrierEdge' => Values::array_get($payload, 'carrier_edge'),
            'sipEdge' => Values::array_get($payload, 'sip_edge'),
            'sdkEdge' => Values::array_get($payload, 'sdk_edge'),
            'clientEdge' => Values::array_get($payload, 'client_edge'),
        ];

        $this->solution = ['callSid' => $callSid, ];
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name)
    {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Insights.V1.EventInstance]';
    }
}

