<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * MagicLogin\Dependencies\Twilio - Numbers
 * This is the public MagicLogin\Dependencies\Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace MagicLogin\Dependencies\Twilio\Rest\Numbers\V2\RegulatoryCompliance\Bundle;

use MagicLogin\Dependencies\Twilio\Exceptions\TwilioException;
use MagicLogin\Dependencies\Twilio\InstanceResource;
use MagicLogin\Dependencies\Twilio\Values;
use MagicLogin\Dependencies\Twilio\Version;
use MagicLogin\Dependencies\Twilio\Deserialize;


/**
 * @property string|null $sid
 * @property string|null $bundleSid
 * @property string|null $accountSid
 * @property string|null $objectSid
 * @property \DateTime|null $dateCreated
 * @property string|null $url
 */
class ItemAssignmentInstance extends InstanceResource
{
    /**
     * Initialize the ItemAssignmentInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $bundleSid The unique string that we created to identify the Bundle resource.
     * @param string $sid The unique string that we created to identify the Identity resource.
     */
    public function __construct(Version $version, array $payload, string $bundleSid, string $sid = null)
    {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'sid' => Values::array_get($payload, 'sid'),
            'bundleSid' => Values::array_get($payload, 'bundle_sid'),
            'accountSid' => Values::array_get($payload, 'account_sid'),
            'objectSid' => Values::array_get($payload, 'object_sid'),
            'dateCreated' => Deserialize::dateTime(Values::array_get($payload, 'date_created')),
            'url' => Values::array_get($payload, 'url'),
        ];

        $this->solution = ['bundleSid' => $bundleSid, 'sid' => $sid ?: $this->properties['sid'], ];
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     *
     * @return ItemAssignmentContext Context for this ItemAssignmentInstance
     */
    protected function proxy(): ItemAssignmentContext
    {
        if (!$this->context) {
            $this->context = new ItemAssignmentContext(
                $this->version,
                $this->solution['bundleSid'],
                $this->solution['sid']
            );
        }

        return $this->context;
    }

    /**
     * Delete the ItemAssignmentInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool
    {

        return $this->proxy()->delete();
    }

    /**
     * Fetch the ItemAssignmentInstance
     *
     * @return ItemAssignmentInstance Fetched ItemAssignmentInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): ItemAssignmentInstance
    {

        return $this->proxy()->fetch();
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name)
    {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Numbers.V2.ItemAssignmentInstance ' . \implode(' ', $context) . ']';
    }
}

