<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * MagicLogin\Dependencies\Twilio - Ip_messaging
 * This is the public MagicLogin\Dependencies\Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace MagicLogin\Dependencies\Twilio\Rest\IpMessaging\V1\Service;

use MagicLogin\Dependencies\Twilio\Options;
use MagicLogin\Dependencies\Twilio\Values;

abstract class UserOptions
{
    /**
     * @param string $roleSid 
     * @param string $attributes 
     * @param string $friendlyName 
     * @return CreateUserOptions Options builder
     */
    public static function create(
        
        string $roleSid = Values::NONE,
        string $attributes = Values::NONE,
        string $friendlyName = Values::NONE

    ): CreateUserOptions
    {
        return new CreateUserOptions(
            $roleSid,
            $attributes,
            $friendlyName
        );
    }




    /**
     * @param string $roleSid 
     * @param string $attributes 
     * @param string $friendlyName 
     * @return UpdateUserOptions Options builder
     */
    public static function update(
        
        string $roleSid = Values::NONE,
        string $attributes = Values::NONE,
        string $friendlyName = Values::NONE

    ): UpdateUserOptions
    {
        return new UpdateUserOptions(
            $roleSid,
            $attributes,
            $friendlyName
        );
    }

}

class CreateUserOptions extends Options
    {
    /**
     * @param string $roleSid 
     * @param string $attributes 
     * @param string $friendlyName 
     */
    public function __construct(
        
        string $roleSid = Values::NONE,
        string $attributes = Values::NONE,
        string $friendlyName = Values::NONE

    ) {
        $this->options['roleSid'] = $roleSid;
        $this->options['attributes'] = $attributes;
        $this->options['friendlyName'] = $friendlyName;
    }

    /**
     * 
     *
     * @param string $roleSid 
     * @return $this Fluent Builder
     */
    public function setRoleSid(string $roleSid): self
    {
        $this->options['roleSid'] = $roleSid;
        return $this;
    }

    /**
     * 
     *
     * @param string $attributes 
     * @return $this Fluent Builder
     */
    public function setAttributes(string $attributes): self
    {
        $this->options['attributes'] = $attributes;
        return $this;
    }

    /**
     * 
     *
     * @param string $friendlyName 
     * @return $this Fluent Builder
     */
    public function setFriendlyName(string $friendlyName): self
    {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.IpMessaging.V1.CreateUserOptions ' . $options . ']';
    }
}




class UpdateUserOptions extends Options
    {
    /**
     * @param string $roleSid 
     * @param string $attributes 
     * @param string $friendlyName 
     */
    public function __construct(
        
        string $roleSid = Values::NONE,
        string $attributes = Values::NONE,
        string $friendlyName = Values::NONE

    ) {
        $this->options['roleSid'] = $roleSid;
        $this->options['attributes'] = $attributes;
        $this->options['friendlyName'] = $friendlyName;
    }

    /**
     * 
     *
     * @param string $roleSid 
     * @return $this Fluent Builder
     */
    public function setRoleSid(string $roleSid): self
    {
        $this->options['roleSid'] = $roleSid;
        return $this;
    }

    /**
     * 
     *
     * @param string $attributes 
     * @return $this Fluent Builder
     */
    public function setAttributes(string $attributes): self
    {
        $this->options['attributes'] = $attributes;
        return $this;
    }

    /**
     * 
     *
     * @param string $friendlyName 
     * @return $this Fluent Builder
     */
    public function setFriendlyName(string $friendlyName): self
    {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.IpMessaging.V1.UpdateUserOptions ' . $options . ']';
    }
}

