<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * MagicLogin\Dependencies\Twilio - Insights
 * This is the public MagicLogin\Dependencies\Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace MagicLogin\Dependencies\Twilio\Rest\Insights\V1;

use MagicLogin\Dependencies\Twilio\Exceptions\TwilioException;
use MagicLogin\Dependencies\Twilio\Options;
use MagicLogin\Dependencies\Twilio\Values;
use MagicLogin\Dependencies\Twilio\Version;
use MagicLogin\Dependencies\Twilio\InstanceContext;
use MagicLogin\Dependencies\Twilio\Serialize;


class SettingContext extends InstanceContext
    {
    /**
     * Initialize the SettingContext
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(
        Version $version
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        ];

        $this->uri = '/Voice/Settings';
    }

    /**
     * Fetch the SettingInstance
     *
     * @param array|Options $options Optional Arguments
     * @return SettingInstance Fetched SettingInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(array $options = []): SettingInstance
    {

        $options = new Values($options);

        $params = Values::of([
            'SubaccountSid' =>
                $options['subaccountSid'],
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded' ]);
        $payload = $this->version->fetch('GET', $this->uri, $params, [], $headers);

        return new SettingInstance(
            $this->version,
            $payload
        );
    }


    /**
     * Update the SettingInstance
     *
     * @param array|Options $options Optional Arguments
     * @return SettingInstance Updated SettingInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(array $options = []): SettingInstance
    {

        $options = new Values($options);

        $data = Values::of([
            'AdvancedFeatures' =>
                Serialize::booleanToString($options['advancedFeatures']),
            'VoiceTrace' =>
                Serialize::booleanToString($options['voiceTrace']),
            'SubaccountSid' =>
                $options['subaccountSid'],
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded' ]);
        $payload = $this->version->update('POST', $this->uri, [], $data, $headers);

        return new SettingInstance(
            $this->version,
            $payload
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Insights.V1.SettingContext ' . \implode(' ', $context) . ']';
    }
}
